/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data.pack;

import java.util.List;

public record SeriesMetaData(String title, String description, int difficulty, List<List<String>> requiredSeries) implements Comparable<SeriesMetaData>
{
    public static final int MIN_DIFFICULTY = 1;
    public static final int MAX_DIFFICULTY = 10;

    public SeriesMetaData(String title) {
        this(title, "", 5);
    }

    public SeriesMetaData(String title, String description) {
        this(title, description, 5);
    }

    public SeriesMetaData(String title, String description, int difficulty) {
        this(title, description, difficulty, List.of());
    }

    public SeriesMetaData(String title, String description, int difficulty, List<List<String>> requiredSeries) {
        this.title = title;
        this.description = description;
        this.difficulty = Math.max(1, Math.min(10, difficulty));
        this.requiredSeries = requiredSeries;
    }

    @Override
    public int compareTo(SeriesMetaData other) {
        int c = Integer.compare(this.difficulty, other.difficulty);
        return c == 0 ? this.title.compareTo(other.title) : c;
    }
}

